<?php
use App\Http\Controllers\PagesController;


/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});





Route::middleware('auth:sanctum')->group( function () {
    
    Route::resource('pages', PagesController::class);  
    Route::get('pages', [PagesController::class, 'index']);
    Route::post('pages/create', [PagesController::class, 'create']);
    Route::get('pages/{id}', [PagesController::class, 'show']);
    Route::put('pages/{id}', [PagesController::class, 'update']);
    Route::delete('pages/{id}', [PagesController::class, 'destroy']);
   
});