<?php
namespace App\Http\Middleware;

use Illuminate\Auth\Middleware\Authenticate as Middleware;

class Authenticate extends Middleware
{
    protected function redirectTo($request)
    {
        // Se for um pedido de API, retornar uma resposta JSON
        if ($request->expectsJson()) {
            abort(response()->json(['message' => 'Token de autenticação inválido ou não fornecido.'], 401));
        }

        // Se não for um pedido de API, redirecionar para a rota de login
        return route('login'); // Aqui está o problema
    }
}

